"""Our main visual theme"""

import serge.blocks.themes

# These are groups of levels which are enabled after completing certain levels
LEVEL_GROUP_1 = [5, 6, 7, 8]
LEVEL_GROUP_2 = [9, 10, 11, 12]

theme = serge.blocks.themes.Manager()
theme.load({
    'main' : ('', {
    
    # Main properties
    'screen-height' : 600,
    'screen-width' : 960,
    'screen-title' : 'Exogene',
    'screen-icon' : 'icon',
    'screenshot-size' : (0, 0, 960, 600),
    
    # Game board properties
    'board-position' : (480, 300),
    'board-cell-size' : (16, 16),        
    
    # Start screen items
    'logo-position' : (480, 50),
    'start-bg-position' : (480, 300),
    'level-grid' : {
        'size' : (4,3),
        'width' : 800,
        'height' : 350,
        'background_colour' : (118, 57, 19, 100),
    },
    'level-grid-center-position' : (480, 290),
    'level-grid-bg-zoom' : 0.15,
    'level-button-text' : {
        'font_size' : 18,
        'text_colour' : (255, 255, 0, 255),
        'justify' : 'center',
    },
    'level-highlight' : {
        'colour' : (200, 200, 200, 100),
    },
    'level-highlight-size' : (170, 110),
    'version-text' : {
        'colour' : (194, 194, 194),
        'font_size' : 16,
    },
    'version-text-position' : (920, 580),
    'credits-text' : {
        'colour' : (194, 194, 194),
        'font_size' : 16,
    },
    'credits-text-position' : (45, 580),
    'achievements-text' : {
        'colour' : (194, 194, 194),
        'font_size' : 28,
    },
    'achievements-text-position' : (480, 570),
    'pain-active-time' : 0.1, # seconds to show the pain indicator
    
    # Modes
    'modes-width' : 350,
    'modes-style' : {
        'width' : 130,
        'height' : 40,
        'on_colour' : (200, 200, 200, 100),
        'off_colour' : (50, 50, 50, 100),
        'font_size' : 18,
        'font_colour' : (255, 255, 0, 255),
    },
    'modes-bar-width' : 800,
    'modes-bar-height' : 60,
    'modes-bar-background-colour' : (118, 57, 19, 100),
    'modes-bar-position' : (480, 495),
    'mode-label-font-size' : 18,
    'mode-label-font-colour' : (255, 255, 0, 255),
    
    # Sound settings
    'mute-button-position' : (35, 35),
    'mute-button-alpha' : 0.4,
    
    # Global things
    'enemy-interval' : 1000.0,
    'enemy-damage-counter' : 0.025,
    'start-level' : 1,
    'dps-length-equivalence' : 1.0, # 1 hp/s is equivalent to this number of squares 
    'pre-stop-pause' : 0.5, # seconds, time to wait when quiting to allow the music to fade
    
    # Selection properties
    'selection-colour' : (255, 0, 0, 255),
    'selection-width' : 0,
    
    # Main menu
    'main-menu-position' : (480, 600-64/2),
    'main-menu-width' : 5*100,
    'main-menu-height' : 64,
    'main-menu-colour' : (0, 0, 0, 50),
    
    # Turret menu
    'turret-menu-width' : 100,
    'turret-menu-height' : 64,
    'turret-menu-off-colour' : (50, 50, 50, 128),
    'turret-menu-on-colour' : (100, 100, 100, 128),
    'turret-menu-selected-colour' : (150, 150, 150, 255),
    'turret-menu-font-size' : 12,
    'turret-menu-font-colour' : (255, 255, 0, 255),

    # Score menu
    'score-menu-width' : 100,
    'score-menu-height' : 64,
    'score-menu-colour' : (50, 50, 50, 255),
    'score-menu-font-size' : 14,
    'score-menu-font-colour' : (255, 255, 0, 255),
    
    # Pop out menu
    'popout-menu-width' : 100,
    'popout-menu-height' : 96,
    'popout-menu-offset' : 80,
    
    # Main titles
    'main-title-size' : 45,
    'main-title-colour' : (255, 255, 255, 255),
    'main-title-position' : (480, 260),
    'sub-title-size' : 30,
    'sub-title-colour' : (255, 255, 255, 255),
    'sub-title-position' : (480, 330),
    'sub-title-2-position' : (480, 420),
    'sub-title-button-size' : (240, 60),
    'sub-title-button-colour' : (0, 0, 0, 50),
    'sub-title-button-stroke' : 3,
    'sub-title-button-stroke-colour' : (0, 0, 0, 100),
    
    'red-phaser' : (250, 255, 1),
    'green-phaser' : (250, 255, 4),
    'blue-phaser' : (250, 255, 4),
    
    # Ice properties
    'ice-frozen-cell' : 3,

    # Cheating properties
    'cheat-goal-position' : (50, 550),
    'cheat-smart-position' : (50, 570),
    'cheat-fps-position' : (50, 590),
    'cheat-size' : 10,
    'cheat-colour' : (255, 0, 0, 255),
    
    # Base damage progress bar
    'base-damage-size' : (80, 20), 
    'base-damage-colours' : [
        (0, 20, (255, 0, 0, 255)),
        (20, 40, (255, 255, 0, 255)),
        (40, 100, (0, 255, 0, 255)),
    ],
    'base-damage-border-width' : 1,
    'base-damage-border-colour' : (255, 255, 0, 255),
    
    }),



    ### Levels ###
    
    'levels' : ('main', {
        'name' : 'A level',
        'show-tiles' : True,
        'background' : None,
        'foreground' : None,
        'locked' : True,
        'completed' : False,
        'waves' : [
            '1111-1111',
            '1122-3322',
            '2233-3112',
        ],
        'initial-cash' : 300,   # The money you have to start the level
        'test-turrets' : [],
        'unlocks' : 'next', # next or a list of levels to unlock
        'initial-intelligence' : 0.0, # how intelligent to start off
        'test-turrets' : [
            ('turret-1', (10, 15)),
            ('turret-1', (40, 7)),
        ],
        'hints' : [],
    }),
    
    'level-1' : ('levels', {
        'name' : 'Training',
        'background' : 'level-1-bg',
        #'foreground' : 'level-1-fg',
        'show-tiles' : False,
        'locked' : False,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
        ],
        'hints' : [
            (0.0, 30.0, 'hint1', (312, 283)),
            (20.0, 50.0, 'hint2', (686, 250)),
        ],
    }),
    'level-2' : ('levels', {
        'name' : 'Treble Trouble',
        'background' : 'level-2-bg',
        'show-tiles' : False,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
        ],
        'hints' : [
            (5.0, 20.0, 'hint3', (515, 193)),
            (25.0, 35.0, 'hint4', (512, 77)),
        ],
    }),
    'level-3' : ('levels', {
        'name' : 'Two by Two',
        'background' : 'level-3-bg',
        'show-tiles' : False,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-3333-2222',
            '2222-3333-3333-4444',
        ],
    }),
    'level-4' : ('levels', {
        'name' : 'Tri-channels',
        'background' : 'level-4-bg',
        'show-tiles' : False,
        'initial-cash' : 800,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-3333-2222',
            '4444-4444-2222-4444',
            '4444-4444-2222-4444',
        ],
        'unlocks' : LEVEL_GROUP_1,
    }),
    'level-5' : ('levels', {
        'name' : 'Islands',
        'background' : 'level-5-bg',
        'show-tiles' : False,
        'initial-cash' : 800,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-3333-2222',
            '4444-4444-2222-4444',
            '4444-4444-2222-4444',
            '2222-3333-5533-2222',
            '2222-3333-3333-2222',
        ],
        'unlocks' : LEVEL_GROUP_2,
    }),    
    'level-6' : ('levels', {
        'name' : 'Asymmetry',
        'background' : 'level-6-bg',
        'show-tiles' : False,
        'initial-cash' : 600,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
        ],
        'unlocks' : LEVEL_GROUP_2,
    }),
    'level-7' : ('levels', {
        'name' : 'The Cave',
        'background' : 'level-7-bg',
        'show-tiles' : False,
        'initial-cash' : 600,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
        ],
        'unlocks' : LEVEL_GROUP_2,
    }),
    'level-8' : ('levels', {
        'name' : 'Back Scatter',
        'background' : 'level-8-bg',
        'show-tiles' : False,
        'initial-cash' : 600,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
        ],
        'unlocks' : LEVEL_GROUP_2,
    }),
    'level-9' : ('levels', {
        'name' : 'Inside Out',
        'background' : 'level-9-bg',
        'show-tiles' : False,
        'initial-cash' : 500,
        'waves' : [
            '1111-1111-1111-1111',
            '2222-1111-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
        ],
    }),

    'level-10' : ('levels', {
        'name' : 'The Chamber',
        'background' : 'level-10-bg',
        'show-tiles' : False,
        'initial-cash' : 500,
        'waves' : [
            '1111-2222-1111-2222',
            '2222-1155-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
            '4444-4444-5511-4444',
            '4444-4444-5511-4444',
        ],
        'initial-intelligence' : 60.0, # how intelligent to start off
    }),
    'level-11' : ('levels', {
        'name' : 'The Heart',
        'background' : 'level-11-bg',
        'show-tiles' : False,
        'initial-cash' : 500,
        'waves' : [
            '1111-2222-1111-2222',
            '2222-1155-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
            '4444-4444-5511-4444',
            '4444-4444-5511-4444',
        ],
    }),
    'level-12' : ('levels', {
        'name' : 'Pandemonium',
        'background' : 'level-12-bg',
        'show-tiles' : False,
        'initial-cash' : 8000,
        'waves' : [
            '1111-2222-1111-2222',
            '2222-1155-2222-1111',
            '2222-3333-3333-2222',
            '2222-3333-5533-2222',
            '4444-4444-5511-4444',
            '4444-4444-2222-4444',
            '2222-3333-3333-2222',
            '2222-3333-3333-1155',
            '4444-4444-5511-4444',
            '4444-4444-5511-4444',
        ],
    }),


    ### Enemies ###
    
    'enemy' : ('main', {
        'speed' : 50.0,  # Pixels per second
        'hp' : 20,       # Number of hit points
        'damage' : 10,   # Damage inflicted to the base
        'score' : 25,    # Score for destroying this enemy
        'cash' : 25,     # Cash for destroying this enemy
        'wait-limit' : 20,    # Cycles: maximum number of cycles to remain stopped before allowing overlapping
        'wait-restart' : 50,  # Cycles: after allowing overlapping, how long to keep allowing
        'movement-see-range' : 2, # cells, number of cells ahead and behind to check for walls when moving
        'movement-path-range' : 2, # path points, number of points ahead to take account of 
        'speed-recovery' : 6.0, # %/second, amount of speed to recover per second
        'rotation-speed' : 1.0, # degreses, rotation speed per frame
        'ai' : 'base', # base/full, determines which AI to use for pathing
    }),
    
    'enemy-1' : ('enemy', {
        'name' : 'Basic',
    }),
    'enemy-2' : ('enemy', {
        'name' : 'Speedy',
        'speed' : 70.0, # Pixels per second
        'hp' : 15,       # Number of hit points
        'rotation-speed' : 2.0, # degreses, rotation speed per frame
    }),
    'enemy-3' : ('enemy', {
        'name' : 'Strong',
        'speed' : 40.0,  # Pixels per second
        'hp' : 30,       # Number of hit points
        'rotation-speed' : -0.5, # degreses, rotation speed per frame
    }),
    'enemy-4' : ('enemy', {
        'name' : 'Killers',
        'speed' : 60.0,  # Pixels per second
        'hp' : 50,       # Number of hit points
        'rotation-speed' : 5.0, # degreses, rotation speed per frame
    }),
    'enemy-5' : ('enemy', {
        'ai' : 'full', # base/full, determines which AI to use for pathing
        'rotation-speed' : 10.0, # degreses, rotation speed per frame
        'speed' : 90.0, # Pixels per second
        'damage' : 20,   # Damage inflicted to the base
    }),

    ### Turrets ###
    
    'turrets' : ('main', {
        'name' : 'A turret',
        'description' : 'A turret that fires at enemies',
        'range' : 120, # Pixels
        'speed' : 2,  # Seconds between firing
        'damage' : 5, # Amount of damage inflicted per hit
        'cost' : 100, # Cost to build
        'rotation-speed' : 90, # Degrees per second
        'bullet-sprite' : 'yellow-bullet', # name of the bullet
        'bullet-speed' : 600, # Pixels per second
        'bullet-impact-radius' : 32, # Pixels
        'colour' : (255, 255, 255, 255), # For the selection ring
        'slowdown' : 0.0, # % of speed to slow down when being hit
        
        'size' : (2, 2), # Size in cells
        'firing-accuracy' : 1, # Degrees, how close we have to be before firing
        'rotates' : True,
        'off-sprite' : 'turret-bad',
        'type' : 'turret',
    }),
    
    'turret-1' : ('turrets' , {
        'name' : 'Basic',
        'colour' : (0, 50, 150, 50), # For the selection ring
        'bullet-sprite' : 'blue-bullet', # name of the bullet
    }),
    'turret-2' : ('turrets' , {
        'name' : 'Power',
        'damage' : 12, # Amount of damage inflicted per hit
        'rotation-speed' : 45, # Degrees per second
        'colour' : (0, 90, 0, 50), # For the selection ring
        'cost' : 200, # Cost to build
        'damage' : 15, # Amount of damage inflicted per hit
        'rotation-speed' : 45, # Degrees per second
        'speed' : 3,  # Seconds between firing
        'bullet-sprite' : 'green-bullet', # name of the bullet
    }),
    'turret-3' : ('turrets' , {
        'name' : 'Sniper',
        'range' : 240, # Pixels
        'colour' : (230, 230, 0, 50), # For the selection ring
        'cost' : 250, # Cost to build
        'damage' : 50, # Amount of damage inflicted per hit
        'rotation-speed' : 120, # Degrees per second
        'speed' : 5,  # Seconds between firing
        'bullet-speed' : 1000, # Pixels per second
        'bullet-sprite' : 'orange-bullet', # name of the bullet
    }),
    'turret-4' : ('turrets' , {
        'name' : 'Stopper',
        'colour' : (255, 50, 0, 50), # For the selection ring
        'slowdown' : 50.0, # % of speed to slow down when being hit
        'damage' : 3, # Amount of damage inflicted per hit
        'speed' : 3,  # Seconds between firing
        'cost' : 250, # Cost to build
        'bullet-sprite' : 'red-bullet', # name of the bullet
    }),
    
##    'turret-6' : ('turrets', {
##        'name' : 'Ice block',
##        'cost' : 20,
##        'range' : 40,
##        'damage' : None,
##        'speed' : None,
##        'rotates' : False,
##        'off-sprite' : 'ice-bad',
##        'type' : 'ice',
##        'freeze-strength' : 30, # Seconds
##    }),
    
    'ai' : ('main', {
    
        'goal-change-range' : (30, 60), # Time in seconds between goal changes
        'initial-goal' : 1,
        'smartness-increase' : 5, # % ammount to increase every goal change
    }),
    
    
    'achievements' : ('main', {
        # Properties of the achievements system
        'banner-duration' : 5,
        'banner-position' : (790, 45),
        'banner-size' : (300, 50),
        'banner-backcolour' : (0, 0, 0, 50),
        'banner-font-colour' : (255, 255, 0, 255),
        'banner-name-size' : 16,
        'banner-description-size' : 12,
        'banner-name-position' : (-100, -18),
        'banner-description-position' : (-100, 0),
        'banner-font-name' : 'DEFAULT',
        'banner-graphic-position' : (-125, 0),
        
        'time-colour' : (255, 255, 255, 100),
        'time-size' : 10,
        'time-position' : (-100, 24),
        
        'logo-position' : (480, 50),
        'screen-background-sprite' : 'start-bg',
        'screen-background-position' : (480, 300),
        'grid-size' : (2, 5),
        'grid-width' : 800,
        'grid-height' : 400,
        'grid-position' : (480, 320),
        
        'back-colour' : (194, 194, 194, 255),
        'back-font-size' : 28,
        'back-font-name' : 'DEFAULT',
        'back-position' : (480, 570),
        'back-sound' : None,
    }),

    
    '__default__' : 'main',

})

G = theme.getProperty
